<?php
/*--------------------------------------------------------------------------------------------------
    ServiceProvider.php 2020-3-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Stock\SellingUnitStock;

use Gambio\Core\Event\EventListenerProvider;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSellingUnitStockInfoEvent;
use Gambio\Shop\Stock\SellingUnitStock\Database\Listeners\OnGetSellingUnitStockInfoEventListener;
use League\Container\Container;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;
use Psr\EventDispatcher\EventDispatcherInterface;

/**
 * @property  Container container
 */
class ServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    /**
     * @var array
     */
    protected $provides = [OnGetSellingUnitStockInfoEventListener::class];

    /**
     * @inheritDoc
     */
    public function boot()
    {
        /** @var EventListenerProvider $listenerProvider */
        $listenerProvider = $this->container->get(EventListenerProvider::class);
        $listenerProvider->attachListener(OnGetSellingUnitStockInfoEvent::class,
            OnGetSellingUnitStockInfoEventListener::class);

    }

    /**
     * @inheritDoc
     */
    public function register()
    {
        $this->container->share(OnGetSellingUnitStockInfoEventListener::class)->addArgument(EventDispatcherInterface::class);
    }
}